/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.EntityListCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.SpawnInfo;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.mods.DLDungeons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class MobInfo {
    public static Map<Class, MobInfo> mobClassToInfo = new HashMap<Class, MobInfo>();
    public static Map<String, MobInfo> mobNameToInfo = new HashMap<String, MobInfo>();
    public static boolean subspeciesTags = true;
    public static boolean ownerTags = true;
    public static boolean tamingEnabled = true;
    public static boolean mountingEnabled = true;
    public static boolean mountingFlightEnabled = true;
    public static boolean mobsAttackVillagers = true;
    public static boolean predatorsAttackAnimals = true;
    public static boolean subspeciesSpawn = true;
    public static boolean randomSizes = true;
    public static boolean friendlyFire = true;
    public static double beastiaryAddOnDeathChance = 0.15;
    public static double bossAntiFlight = 3.0;
    public static boolean disablePickupOffsets = false;
    public static Map<String, Double> difficultyMutlipliers = new HashMap<String, Double>();
    public static List<String> summonableCreatures = new ArrayList<String>();
    public static List<String> tameableCreatures = new ArrayList<String>();
    public static Map<String, GroupInfo> mobGroups = new HashMap<String, GroupInfo>();
    public static boolean dlDungeonsLoaded = false;
    public GroupInfo group;
    public int mobID;
    public String name = "mobname";
    public boolean mobEnabled = true;
    public Class entityClass;
    public SpawnInfo spawnInfo;
    public Map<Integer, Subspecies> subspecies = new HashMap<Integer, Subspecies>();
    public int subspeciesAmount = 0;
    public int eggBackColor;
    public int eggForeColor;
    public boolean defaultDrops = true;
    public List<DropRate> customDrops = new ArrayList<DropRate>();
    public boolean boss = false;
    public boolean dummy = false;
    public boolean peacefulDifficulty;
    public int summonCost = 1;
    public String dungeonThemes = "GROUP";
    public int dungeonLevel = -1;
    public double sizeScale = 1.0;
    public double hitboxScale = 1.0;
    public double multiplierHealth = 1.0;
    public double multiplierDefense = 1.0;
    public double multiplierSpeed = 1.0;
    public double multiplierDamage = 1.0;
    public double multiplierHaste = 1.0;
    public double multiplierEffect = 1.0;
    public double multiplierPierce = 1.0;
    public int boostHealth = 0;
    public int boostDefense = 0;
    public int boostSpeed = 0;
    public int boostDamage = 0;
    public int boostHaste = 0;
    public int boostEffect = 0;
    public int boostPierce = 0;

    public static void loadGlobalSettings() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "general");
        config.setCategoryComment("GUI", "Mostly client side settings that affect visuals such as mob names or inventory tabs, etc.");
        subspeciesTags = config.getBool("GUI", "Subspecies Tags", subspeciesTags, "If true, all mobs that are a subspecies will always show their nametag.");
        config.setCategoryComment("Pets", "Here you can control all settings related to taming and mounting.");
        ownerTags = config.getBool("Pets", "Owner Tags", ownerTags, "If true, tamed mobs will display their owner's name in their name tag.");
        tamingEnabled = config.getBool("Pets", "Taming", tamingEnabled, "Set to false to disable pet/mount taming.");
        mountingEnabled = config.getBool("Pets", "Mounting", mountingEnabled, "Set to false to disable mounts.");
        mountingFlightEnabled = config.getBool("Pets", "Flying Mounting", mountingFlightEnabled, "Set to false to disable flying mounts, if all mounts are disable this option doesn't matter.");
        friendlyFire = config.getBool("Pets", "Friendly Fire", friendlyFire, "If true, pets, minions, etc can't harm their owners (with ranged attacks, etc).");
        config.setCategoryComment("Beastiary", "Here you can control all settings related to the player's Beastiary.");
        beastiaryAddOnDeathChance = config.getDouble("Beastiary", "Add Creature On Kill Chance", beastiaryAddOnDeathChance, "The chance that creatures are added to the player's Beastiary when killed, the Soulgazer can also be used to add creatures. Bosses are always a 100% chance.");
        config.setCategoryComment("Bosses", "Here you can control all settings related to boss creatures, this does not include rare subspecies (mini bosses).");
        bossAntiFlight = config.getDouble("Bosses", "How much higher players must be relative to a boss' y position (feet) to trigger anti flight measures.");
        config.setCategoryComment("Mob Interaction", "Here you can control how mobs interact with other mobs.");
        predatorsAttackAnimals = config.getBool("Mob Interaction", "Predators Attack Animals", predatorsAttackAnimals, "Set to false to prevent predator mobs from attacking animals/farmable mobs.");
        mobsAttackVillagers = config.getBool("Mob Interaction", "Mobs Attack Villagers", mobsAttackVillagers, "Set to false to prevent mobs that attack players from also attacking villagers.");
        disablePickupOffsets = config.getBool("Mob Interaction", "Disable Pickup Offset", disablePickupOffsets, "If true, when a mob picks up a player, the player will be positioned where the mob is rather than offset to where the mob is holding the player at.");
        config.setCategoryComment("Mob Variations", "Settings for how mobs randomly vary such as subspecies. Subspecies are uncommon and rare variants of regular mobs, uncommon subspecies tend to be a bit tougher and rare subspecies are quite powerful and can be considered as mini bosses..");
        subspeciesSpawn = config.getBool("Mob Variations", "Subspecies Can Spawn", subspeciesSpawn, "Set to false to prevent subspecies from spawning, this will not affect mobs that have already spawned as subspecies.");
        randomSizes = config.getBool("Mob Variations", "Random Sizes", randomSizes, "Set to false to prevent mobs from having a random size variation when spawning, this will not affect mobs that have already spawned.");
        Subspecies.loadGlobalSettings(config);
        String[] difficultyNames = new String[]{"Easy", "Normal", "Hard"};
        double[] difficultyDefaults = new double[]{0.5, 1.0, 1.1};
        String[] statNames = new String[]{"Health", "Defense", "Speed", "Damage", "Haste", "Effect", "Pierce"};
        difficultyMutlipliers = new HashMap<String, Double>();
        config.setCategoryComment("Difficulty Multipliers", "Here you can scale the stats of every mob on a per difficulty basis. Note that on easy, speed is kept at 1.0 by default as 0.5 makes them stupidly slow.");
        int difficultyIndex = 0;
        for (String difficultyName : difficultyNames) {
            for (String statName : statNames) {
                double defaultValue = difficultyDefaults[difficultyIndex];
                if ("Easy".equalsIgnoreCase(difficultyName) && ("Health".equalsIgnoreCase(statName) || "Speed".equalsIgnoreCase(statName))) {
                    defaultValue = 1.0;
                }
                if ("Hard".equalsIgnoreCase(difficultyName) && "Speed".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                difficultyMutlipliers.put((difficultyName + "-" + statName).toUpperCase(), config.getDouble("Difficulty Multipliers", difficultyName + " " + statName, defaultValue));
            }
            ++difficultyIndex;
        }
    }

    public static MobInfo getFromName(String mobName) {
        if (!mobNameToInfo.containsKey(mobName = mobName.toLowerCase())) {
            return null;
        }
        return mobNameToInfo.get(mobName);
    }

    public static MobInfo getFromClass(Class mobClass) {
        if (!mobNameToInfo.containsKey(mobClass)) {
            return null;
        }
        return mobNameToInfo.get(mobClass);
    }

    public static void loadAllFromConfigs(GroupInfo group) {
        for (MobInfo mobInfo : mobNameToInfo.values()) {
            if (mobInfo == null || mobInfo.group != group) continue;
            mobInfo.loadFromConfigs();
        }
    }

    public static void loadAllSpawningFromConfigs() {
        for (MobInfo mobInfo : mobNameToInfo.values()) {
            if (mobInfo == null) continue;
            mobInfo.spawnInfo.loadFromConfig();
        }
    }

    public MobInfo(GroupInfo group, String name, Class entityClass, int eggBack, int eggFore) {
        this.group = group;
        this.group.mobInfos.add(this);
        if (!mobGroups.containsKey(group.filename)) {
            mobGroups.put(group.filename, group);
        }
        this.mobID = this.group.getNextMobID();
        this.name = name;
        this.entityClass = entityClass;
        this.eggBackColor = eggBack;
        this.eggForeColor = eggFore;
        this.spawnInfo = new SpawnInfo(this);
        mobClassToInfo.put(entityClass, this);
        mobNameToInfo.put(this.name, this);
    }

    public void loadFromConfigs() {
        if (this.dummy) {
            return;
        }
        ConfigBase config = ConfigBase.getConfig(this.group, "general");
        config.setCategoryComment("Enabled Mobs", "Here you can completely disable any mob.");
        this.mobEnabled = config.getBool("Enabled Mobs", this.getCfgName("Enabled"), this.mobEnabled);
        config.setCategoryComment("Peaceful Mob", "Here you may control whether or not each mob is allowed in Peaceful Difficulty.");
        this.peacefulDifficulty = config.getBool("Peaceful Mobs", this.getCfgName("On Peaceful"), this.peacefulDifficulty);
        config.setCategoryComment("Summoning Costs", "How much summoning focus each mob costs. This includes mobs that can't be summoned by the summoning staff as there might be other methods of summoning them in the future.");
        this.summonCost = config.getInt("Summoning Costs", this.getCfgName("Summoning Cost"), this.summonCost);
        config.setCategoryComment("Dungeon Themes", "Here you can set the Dungeon Theme of each mob. These are used by Doomlike Dungeons and might be used by other things later.");
        this.dungeonThemes = config.getString("Dungeon Themes", this.getCfgName("Themes"), this.dungeonThemes);
        config.setCategoryComment("Dungeon Levels", "The dungeon level of this mob, used by Doomlike Dungeons. -1 = Not for Dungeons, 0 = Common, 1 = Tough, 2 = Brute, 3 = Elite");
        this.dungeonLevel = config.getInt("Dungeon Level", this.getCfgName("Dungeon Level"), this.dungeonLevel);
        this.dungeonLevel = Math.min(3, Math.max(-1, this.dungeonLevel));
        if (dlDungeonsLoaded) {
            DLDungeons.addMob(this);
        }
        config.setCategoryComment("Default Item Drops", "If false, only custom item drops are dropped.");
        this.defaultDrops = config.getBool("Default Item Drops", this.getCfgName("Default Drops"), this.defaultDrops);
        config.setCategoryComment("Custom Item Drops", "Allows for custom items drops per mob. Format is: mod:item,metadata,chance,min,max Multiple drops should be semicolon separated and chances are in decimal format. You can also add an additional comma and then a subspecies ID to restrict that drop to a certain subspecies like so: mod:item,metadata,chance,min,max,subspecies. minecraft:wool,2,0.25,0,3 is Green Wool with a 25% drop rate and will drop 0 to 3 blocks. Be sure to use a colon for mod:item and commas for everything else in an entry. Semicolons can be used to separate multiple entries.");
        String customDropsString = config.getString("Custom Item Drops", this.getCfgName("Custom Drops"), "");
        if (customDropsString != null && customDropsString.length() > 0) {
            for (String customDropEntryString : customDropsString.split(";")) {
                String[] customDropValues = customDropEntryString.split(",");
                if (customDropValues.length < 5) continue;
                String dropName = customDropValues[0];
                int dropMeta = Integer.parseInt(customDropValues[1]);
                float dropChance = Math.max(0.0f, Math.min(1.0f, Float.parseFloat(customDropValues[2])));
                int dropMin = Integer.parseInt(customDropValues[3]);
                int dropMax = Integer.parseInt(customDropValues[4]);
                int subspeciesID = -1;
                if (customDropValues.length >= 6) {
                    subspeciesID = Integer.parseInt(customDropValues[5]);
                }
                ItemStack drop = null;
                if (Item.func_111206_d((String)dropName) != null) {
                    drop = new ItemStack(Item.func_111206_d((String)dropName), 1, dropMeta);
                } else if (Block.func_149684_b((String)dropName) != null) {
                    drop = new ItemStack(Block.func_149684_b((String)dropName), 1, dropMeta);
                }
                DropRate dropRate = new DropRate(drop, dropChance).setMinAmount(dropMin).setMaxAmount(dropMax);
                dropRate.setSubspecies(subspeciesID);
                this.customDrops.add(dropRate);
            }
        }
        config = ConfigBase.getConfig(this.group, "stats");
        config.setCategoryComment("Multipliers", "Here you can scale each mob stat,for instance setting 2 will double the stat, setting 0.5 will half it.");
        this.multiplierHealth = config.getDouble("Multipliers", this.getCfgName("Health"), this.multiplierHealth, "The maximum amount of health each mob has. Already spawned mobs will not be affected by any changes. 1 health = half a heart.");
        this.multiplierDefense = config.getDouble("Multipliers", this.getCfgName("Defense"), this.multiplierDefense, "How much damage is blocked, minimum damage dealt is 1.");
        this.multiplierSpeed = config.getDouble("Multipliers", this.getCfgName("Speed"), this.multiplierSpeed, "Movement speed.");
        this.multiplierDamage = config.getDouble("Multipliers", this.getCfgName("Damage"), this.multiplierDamage, "Damage dealt, both melee and ranged.");
        this.multiplierHaste = config.getDouble("Multipliers", this.getCfgName("Haste"), this.multiplierHaste, "Attack and ability speeds.");
        this.multiplierEffect = config.getDouble("Multipliers", this.getCfgName("Effect"), this.multiplierEffect, "Effect strengths and durations.");
        this.multiplierPierce = config.getDouble("Multipliers", this.getCfgName("Pierce"), this.multiplierPierce, "Affects how much damage the mob deals that ignores armor. At 1.0 for every 5 damage dealt, 1 damage ignores armor. At 2.0 for every 3 (2.5 rouded) damage dealt 1 damage ignores armor. At 0.5 for every 10 damage dealt, 1 damage ignores armor.");
        config.setCategoryComment("Boosts", "Here you can increase or decrease each stat by a specific amount. (Use a negative number to decrease.)");
        this.boostHealth = config.getInt("Boosts", this.getCfgName("Health"), this.boostHealth, "The maximum amount of health each mob has. Already spawned mobs will not be affected by any changes. 1 health = half a heart.");
        this.boostDefense = config.getInt("Boosts", this.getCfgName("Defense"), this.boostDefense, "How much damage is blocked, minimum damage dealt is 1.");
        this.boostSpeed = config.getInt("Boosts", this.getCfgName("Speed"), this.boostSpeed, "Movement speed. Average speed is 28");
        this.boostDamage = config.getInt("Boosts", this.getCfgName("Damage"), this.boostDamage, "Damage dealt, both melee and ranged. 1 = half a heart.");
        this.boostHaste = config.getInt("Boosts", this.getCfgName("Haste"), this.boostHaste, "Attack and ability speeds in ticks. Average attack rate is 20 (1 second).");
        this.boostEffect = config.getInt("Boosts", this.getCfgName("Effect"), this.boostEffect, "Effect strengths and durations in ticks (20 ticks = 1 second).");
        this.boostPierce = config.getInt("Boosts", this.getCfgName("Pierce"), this.boostPierce, "Use to directly decrease or increase the piercing value. By default it is 5 so for every 5 damage dealt, 1 damage ignores armor. A positive boost lowers the attack required per armor piercing damage, therefore a boost of 2 will lower the piercing stat from 5 to 3.");
        config.setCategoryComment("Additional", "Here you can control the miscellaneous features of each mob.");
        this.sizeScale = config.getDouble("Additional", this.getCfgName("Size Scale"), this.sizeScale, "A custom scale to apply to the mob's actual size, the hitbox will also scale to match and will then scale again if a custom hitbox scale is set.");
        this.hitboxScale = config.getDouble("Additional", this.getCfgName("Hitbox Scale"), this.hitboxScale, "A custom scale to apply to the mob's hitbox, note that large hitboxes can affect pathing and hitboxes can't be smaller than half a block.");
        this.registerMob();
        int achievementX = this.group.order * 4;
        int achievementY = this.mobID;
        ItemStack achievementStack = new ItemStack(ObjectManager.getItem("mobtoken"));
        achievementStack.func_77983_a("Mob", (NBTBase)new NBTTagString(this.name));
        ObjectManager.addAchievement(this.name + ".kill", new Achievement(this.name + ".kill", this.name + ".kill", achievementX, achievementY, achievementStack, null));
        ObjectManager.addAchievement(this.name + ".learn", new Achievement(this.name + ".learn", this.name + ".learn", achievementX + 1, achievementY, achievementStack, null));
        if (this.isSummonable()) {
            ObjectManager.addAchievement(this.name + ".summon", new Achievement(this.name + ".summon", this.name + ".summon", achievementX + 2, achievementY, achievementStack, null));
        }
        if (this.isTameable()) {
            ObjectManager.addAchievement(this.name + ".tame", new Achievement(this.name + ".tame", this.name + ".tame", achievementX + 2, achievementY, achievementStack, null));
        }
    }

    public void registerMob() {
        LycanitesMobs.printDebug("MobSetup", "~0==================== Mob Setup: " + this.name + " [" + this.mobID + "] ====================0~");
        if (!this.mobEnabled) {
            LycanitesMobs.printDebug("MobSetup", "Mob Disabled: " + this.name + " - " + this.entityClass + " (" + this.group.name + ")");
        }
        if (!ObjectManager.entityLists.containsKey(this.group.filename)) {
            ObjectManager.entityLists.put(this.group.filename, new EntityListCustom());
        }
        ObjectManager.entityLists.get(this.group.filename).addMapping(this.entityClass, this.getRegistryName(), this.eggBackColor, this.eggForeColor);
        EntityRegistry.registerModEntity((Class)this.entityClass, (String)this.name, (int)this.mobID, (Object)this.group.mod, (int)(this.isBoss() ? 256 : 128), (int)(this.isBoss() ? 6 : 3), (boolean)true);
        LycanitesMobs.printDebug("MobSetup", "Mob Added: " + this.name + " - " + this.entityClass + " (" + this.group.name + ")");
    }

    public String getEntityID() {
        return this.name;
    }

    public String getRegistryName() {
        return this.group.filename + "." + this.name;
    }

    public String getCfgName(String configKey) {
        return this.getTitle() + " " + configKey;
    }

    public String getTitle() {
        return I18n.func_74838_a((String)("entity." + this.getRegistryName() + ".name"));
    }

    public String getDescription() {
        return I18n.func_74838_a((String)("entity." + this.getRegistryName() + ".description"));
    }

    public ResourceLocation getIcon() {
        ResourceLocation texture = AssetManager.getTexture(this.name + "_icon");
        if (texture == null) {
            AssetManager.addTexture(this.name + "_icon", this.group, "textures/guis/" + this.name.toLowerCase() + "_icon.png");
            texture = AssetManager.getTexture(this.name + "_icon");
        }
        return texture;
    }

    public MobInfo setPeaceful(boolean bool) {
        this.peacefulDifficulty = bool;
        return this;
    }

    public MobInfo setDungeonThemes(String themes) {
        this.dungeonThemes = themes;
        return this;
    }

    public MobInfo setDungeonLevel(int level) {
        this.dungeonLevel = level;
        return this;
    }

    public MobInfo setSummonCost(int integer) {
        this.summonCost = integer;
        return this;
    }

    public MobInfo setSummonable(boolean summonable) {
        if (summonable && !summonableCreatures.contains(this.name)) {
            summonableCreatures.add(this.name);
        }
        if (!summonable) {
            summonableCreatures.remove(this.name);
        }
        return this;
    }

    public boolean isSummonable() {
        return summonableCreatures.contains(this.name);
    }

    public MobInfo setTameable(boolean tameable) {
        if (tameable && !tameableCreatures.contains(this.name)) {
            tameableCreatures.add(this.name);
        }
        if (!tameable) {
            tameableCreatures.remove(this.name);
        }
        return this;
    }

    public boolean isTameable() {
        if (!tamingEnabled) {
            return false;
        }
        return tameableCreatures.contains(this.name);
    }

    public MobInfo setBoss(boolean bool) {
        this.boss = bool;
        return this;
    }

    public boolean isBoss() {
        return this.boss;
    }

    public MobInfo setDummy(boolean bool) {
        this.dummy = bool;
        return this;
    }

    public MobInfo addSubspecies(Subspecies newSubspecies) {
        ++this.subspeciesAmount;
        if (newSubspecies != null) {
            newSubspecies.mobInfo = this;
            newSubspecies.index = this.subspeciesAmount;
        }
        this.subspecies.put(this.subspeciesAmount, newSubspecies);
        return this;
    }

    public Subspecies getSubspecies(int index) {
        return this.subspecies.get(index);
    }

    public Subspecies getRandomSubspecies(EntityLivingBase entity, boolean rare) {
        LycanitesMobs.printDebug("Subspecies", "~0===== Subspecies =====0~");
        LycanitesMobs.printDebug("Subspecies", "Selecting random subspecies for: " + entity);
        if (rare) {
            LycanitesMobs.printDebug("Subspecies", "The conditions have been set to rare increasing the chances of a subspecies being picked.");
        }
        if (this.subspeciesAmount < 1) {
            LycanitesMobs.printDebug("Subspecies", "No species available, will be base species.");
            return null;
        }
        LycanitesMobs.printDebug("Subspecies", "Subspecies Available: " + this.subspeciesAmount);
        int baseSpeciesWeightScaled = Subspecies.baseSpeciesWeight;
        if (rare) {
            baseSpeciesWeightScaled /= 4;
        }
        int totalWeight = baseSpeciesWeightScaled;
        for (Subspecies subspeciesEntry : this.subspecies.values()) {
            totalWeight += subspeciesEntry.weight;
        }
        LycanitesMobs.printDebug("Subspecies", "Total Weight: " + totalWeight);
        int roll = entity.func_70681_au().nextInt(totalWeight);
        LycanitesMobs.printDebug("Subspecies", "Rolled: " + roll);
        if (roll <= baseSpeciesWeightScaled) {
            LycanitesMobs.printDebug("Subspecies", "Base species selected: " + baseSpeciesWeightScaled);
            return null;
        }
        int checkWeight = baseSpeciesWeightScaled;
        for (Subspecies subspeciesEntry : this.subspecies.values()) {
            if (roll > (checkWeight += subspeciesEntry.weight)) continue;
            LycanitesMobs.printDebug("Subspecies", "Subspecies selected: " + subspeciesEntry.name + " - " + subspeciesEntry.weight);
            return subspeciesEntry;
        }
        LycanitesMobs.printWarning("Subspecies", "The roll was higher than the Total Weight, this shouldn't happen.");
        return null;
    }

    public Subspecies getRandomSubspecies(EntityLivingBase entity) {
        return this.getRandomSubspecies(entity, false);
    }

    public Subspecies getChildSubspecies(EntityLivingBase entity, int hostSubspeciesIndex, Subspecies partnerSubspecies) {
        int partnerSubspeciesIndex;
        Subspecies hostSubspecies = this.getSubspecies(hostSubspeciesIndex);
        int n = partnerSubspeciesIndex = partnerSubspecies != null ? partnerSubspecies.index : 0;
        if (hostSubspeciesIndex == partnerSubspeciesIndex) {
            return hostSubspecies;
        }
        int hostWeight = hostSubspecies != null ? hostSubspecies.weight : Subspecies.baseSpeciesWeight;
        int partnerWeight = partnerSubspecies != null ? partnerSubspecies.weight : Subspecies.baseSpeciesWeight;
        int roll = entity.func_70681_au().nextInt(hostWeight + partnerWeight);
        if (roll > hostWeight) {
            return partnerSubspecies;
        }
        return hostSubspecies;
    }
}

